package org.qas.qtest.api.services.project.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.project.model.UserPermissions;

import java.util.List;

/**
 * ListUserPermissionsJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListUserPermissionsJsonUnmarshaller 2014-12-22 14:53:30z dzungvnguyen $
 * @since 1.0
 */
public final class ListUserPermissionsJsonUnmarshaller extends AbstractUnmarshaller<List<UserPermissions>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  static ListUserPermissionsJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListUserPermissionsJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListUserPermissionsJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<UserPermissions> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<UserPermissions>>() {
    });
  }
}
