package org.qas.qtest.api.services.project.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.project.model.Project;

import java.util.List;

/**
 * ListProjectJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListProjectJsonUnmarshaller 2014-03-27 18:31:30z dungvnguyen $
 * @since 1.0
 */
public final class ListProjectJsonUnmarshaller extends AbstractUnmarshaller<List<Project>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  static ListProjectJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListProjectJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListProjectJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<Project> parse(String data) throws Exception {
    return JsonMapper.fromJson(data, new TypeReference<List<Project>>() {
    });
  }
}
