package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.GetModuleRequest;

/**
 * GetModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetModuleRequestMarshaller 2015-01-16 14:58:30z dzungvnguyen $
 * @since 1.0
 */
public final class GetModuleRequestMarshaller extends AbstractModuleRequestMarshaller<GetModuleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(GetModuleRequest getModuleRequest) throws Exception {
    // validate module request.
    getModuleRequest = ApiPreconditions.notNull(getModuleRequest);
    validateProjectId(getModuleRequest.getProjectId());
    validateModuleId(getModuleRequest.getModuleId());

    // create request.
    Request request = createJsonRequest(getModuleRequest, "GetModule", HttpMethod.GET);

    // create resource builder.
    StringBuilder pathBuilder = createApiPathBuilder(getModuleRequest.getProjectId());
    pathBuilder.append("/").append(getModuleRequest.getModuleId());
    request.setResourcePath(pathBuilder.toString());

    // set request parameter.
    if (getModuleRequest.isIncludeDescendants()) {
      request.addParameter("expand", "descendants");
    }

    // return the request.
    return request;
  }
}
