package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.CreateModuleRequest;

/**
 * CreateModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateModuleRequestMarshaller 2014-05-17 13:27:30z dungvnguyen $
 * @since 1.0
 */
public final class CreateModuleRequestMarshaller
  extends AbstractModuleRequestMarshaller<CreateModuleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(CreateModuleRequest createModuleRequest) throws Exception {
    // validate module request.
    createModuleRequest = ApiPreconditions.notNull(createModuleRequest);
    validateProjectId(createModuleRequest.getProjectId());
    ApiPreconditions.notNull(createModuleRequest.getModule(), "Invalid module passed to marshall(...)");
    ApiPreconditions.checkArgument(
      (createModuleRequest.getParentId() == null || createModuleRequest.getParentId().longValue() > 0L),
      "Invalid parent identifier passed to marshall(...)"
    );

    // create request.
    Request request = createJsonRequest(createModuleRequest, "CreateModule", HttpMethod.POST);
    request.setResourcePath(createApiPathBuilder(createModuleRequest.getProjectId()).toString());

    // set request parameter.
    if (createModuleRequest.getParentId() != null && createModuleRequest.getParentId().longValue() > 0L) {
      request.addParameter("parentId", String.valueOf(createModuleRequest.getParentId().longValue()));
    }

    // set request body content.
    createModuleRequest.getModule().setParentId(createModuleRequest.getParentId());
    request.setContent(new StringInputStream(JsonMapper.toJson(createModuleRequest.getModule())));

    return request;
  }
}
