package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.ApiServiceRequest;
import org.qas.api.AuthServiceException;

/**
 * AbstractModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AbstractModuleRequestMarshaller 2015-06-01 15:26:30z dzungvnguyen $
 * @since 1.0
 */
public abstract class AbstractModuleRequestMarshaller<T extends ApiServiceRequest>
  extends AbstractProjectRequestMarshaller<T> {
  //~ class members ===========================================================
  /**
   * Validate module identifier.
   *
   * @param moduleId the given module identifier to validate.
   * @throws AuthServiceException if an error occurs during validating module identifier.
   */
  static void validateModuleId(Long moduleId) throws AuthServiceException {
    validateId(moduleId, "Invalid module id passed to marshall(...)");
  }

  /**
   * @return API path builder, used to build resource path.
   */
  protected StringBuilder createApiPathBuilder(Long projectId) {
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(projectId));
    pathBuilder.append("/modules");
    return pathBuilder;
  }
}
