package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * UpdateModuleRequest
 *
 * @author Dzung Nguyen
 * @version $Id UpdateModuleRequest 2015-01-16 16:30:30z dzungvnguyen $
 * @since 1.0
 */
public final class UpdateModuleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Module module;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return current update module request.
   */
  public UpdateModuleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return updated module information.
   */
  public Module getModule() {
    return module;
  }

  /**
   * Sets the module information.
   *
   * @param module the given module information to set.
   */
  public void setModule(Module module) {
    this.module = module;
  }

  /**
   * Sets the module information.
   *
   * @param module the given module information to set.
   * @return the current update module request.
   */
  public UpdateModuleRequest withModule(Module module) {
    setModule(module);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(this.getClass().getName());

    builder.append("{").append("\n")
        .append("\t").append("projectId: ").append(projectId).append(",").append("\n")
        .append("\t").append("module: ").append("\n")
        .append(module.toString()).append("\n")
        .append("}");

    return builder.toString();
  }
}
