package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * SearchModuleRequest
 *
 * @author Dzung Nguyen
 * @version $Id SearchModuleRequest 2015-06-01 17:28:30z dzungvnguyen $
 * @since 1.0
 */
public final class SearchModuleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long parentId;
  private String query;
  private boolean includeDescendants = false;

  //~ class members ===========================================================

  /**
   * @return {@code true} if user want to include matched descendants.
   */
  public boolean isIncludeDescendants() {
    return includeDescendants;
  }

  /**
   * Sets the include descendant flag.
   *
   * @param includeDescendants the given include descendants flag to set.
   */
  public void setIncludeDescendants(boolean includeDescendants) {
    this.includeDescendants = includeDescendants;
  }

  /**
   * Sets the include descendant flag.
   *
   * @param includeDescendants the given include descendants flag to set.
   * @return the current module.
   */
  public SearchModuleRequest withIncludeDescendants(boolean includeDescendants) {
    setIncludeDescendants(includeDescendants);
    return this;
  }

  /**
   * @return the parent identifier.
   */
  public Long getParentId() {
    return parentId;
  }

  /**
   * Sets the parent identifier.
   *
   * @param parentId the given parent identifier to set.
   */
  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  /**
   * Sets the parent identifier.
   *
   * @param parentId the given parent identifier to set.
   * @return the current module.
   */
  public SearchModuleRequest withParentId(Long parentId) {
    setParentId(parentId);
    return this;
  }

  /**
   * @return the query parameter.
   */
  public String getQuery() {
    return query;
  }

  /**
   * Sets the search query.
   *
   * @param query the given query value.
   */
  public void setQuery(String query) {
    this.query = query;
  }

  /**
   * Sets the search query.
   *
   * @param query the given query value.
   * @return the current module.
   */
  public SearchModuleRequest withQuery(String query) {
    setQuery(query);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("SearchModuleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", parentId=").append(parentId);
    sb.append(", includeDescendants=").append(includeDescendants);
    sb.append(", query='").append(query).append('\'');
    sb.append('}');
    return sb.toString();
  }
}
