package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * ListModuleRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListModuleRequest 2015-01-16 15:51:30z dzungvnguyen $
 * @since 1.0
 */
public final class ListModuleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long parentModuleId;
  private boolean includeDescendants = false;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the project identifier to set.
   */
  public ListModuleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the parent module identifier.
   */
  public Long getParentModuleId() {
    return parentModuleId;
  }

  /**
   * Sets the parent module identifier.
   *
   * @param moduleId the given module identifier to set.
   */
  public void setParentModuleId(Long moduleId) {
    this.parentModuleId = moduleId;
  }

  /**
   * Sets the parent module identifier.
   *
   * @param moduleId the given module identifier to set.
   * @return current instance.
   */
  public ListModuleRequest withParentModuleId(Long moduleId) {
    setParentModuleId(moduleId);
    return this;
  }

  /**
   * @return include descendants flag.
   */
  public boolean isIncludeDescendants() {
    return includeDescendants;
  }

  /**
   * Sets the include descendants flag.
   *
   * @param includeDescendants the given include descendants flag to set.
   */
  public void setIncludeDescendants(boolean includeDescendants) {
    this.includeDescendants = includeDescendants;
  }

  /**
   * Sets the include descendants flag.
   *
   * @param includeDescendants the given include descendants flag to set.
   * @return current {@link GetModuleRequest get module request} instance.
   */
  public ListModuleRequest withIncludeDescendants(boolean includeDescendants) {
    setIncludeDescendants(includeDescendants);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(this.getClass().getName());

    builder.append("{").append("\n")
        .append("\t").append("projectId: ").append(projectId).append(",").append("\n")
        .append("\t").append("parentModuleId: ").append(parentModuleId).append(",").append("\n")
        .append("\t").append("includeDescendant: ").append(includeDescendants).append("\n")
        .append("}");

    return builder.toString();
  }
}
