package org.qas.qtest.api.services.project.model;

import org.qas.api.JsonMapper;
import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * CreateModuleRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateModuleRequest 2014-05-17 12:57:30z dungvnguyen $
 * @since 1.0
 */
public final class CreateModuleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long parentId;
  private Module module;

  //~ class members ===========================================================
  /**
   * Sets the project identifier to request and return itself.
   *
   * @param projectId the given project identifier to set.
   * @return the current instance.
   */
  public CreateModuleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the parent identifier.
   */
  public Long getParentId() {
    return parentId;
  }

  /**
   * Sets the parent identifier.
   *
   * @param parentId the given parent identifier to set.
   */
  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  /**
   * Sets the parent identifier.
   *
   * @param parentId the given parent identifier to set.
   * @return current instance.
   */
  public CreateModuleRequest withParentId(Long parentId) {
    setParentId(parentId);
    return this;
  }

  /**
   * @return the module data to put into project.
   */
  public Module getModule() {
    return module;
  }

  /**
   * Sets the module data to request.
   *
   * @param module the given module data to set.
   */
  public void setModule(Module module) {
    this.module = module;
  }

  /**
   * Sets the module data to request and return itself.
   *
   * @param module the given module data to set.
   * @return current instance.
   */
  public CreateModuleRequest withModule(Module module) {
    setModule(module);
    return this;
  }

  @Override
  public String toString() {
    return JsonMapper.toJson(this);
  }
}
