package org.qas.qtest.api.services.plan.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.CreateBuildRequest;
import org.qas.qtest.api.services.plan.model.Release;

/**
 * CreateBuildRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateBuildRequestMarshaller 2014-07-18 13:54:30z dungvnguyen $
 * @since 1.0
 */
public class CreateBuildRequestMarshaller extends AbstractMarshaller<Request, CreateBuildRequest> {

  @Override
  protected void validateRequest(CreateBuildRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid request passed to call(...)");
    }

    if (in.getProjectId() == null
      || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project id passed to call(...)");
    }

    if (in.getReleaseId() == null
      || in.getReleaseId() <= 0) {
      throw new AuthClientException("Invalid release id passed to call(...)");
    }

    if (in.getBuild() == null) {
      throw new AuthClientException("Invalid build instance passed to call(...)");
    }
  }

  @Override
  protected void build(Request request, CreateBuildRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "TestPlanService";
  }

  @Override
  protected String getActionName() {
    return "CreateBuild";
  }

  @Override
  protected String getContent(CreateBuildRequest in) throws Exception {
    Build build = in.getBuild();
    build.setRelease(new Release()
      .withId(in.getReleaseId()));
    return JsonMapper.toJson(build);
  }

  @Override
  protected StringBuilder getResourcePath(CreateBuildRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/builds");
  }
}
