package org.qas.qtest.api.services.plan.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.plan.model.Build;

/**
 * BuildJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id BuildJsonUnmarshaller 2014-07-18 12:44:30z dungvnguyen $
 * @since 1.0
 */
public class BuildJsonUnmarshaller extends AbstractUnmarshaller<Build, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static BuildJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static BuildJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new BuildJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public Build parse(String data) throws Exception {
    return JsonMapper.parseJson(data, Build.class);
  }
}
