package org.qas.qtest.api.services.plan.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateBuildRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateBuildRequest 2014-07-18 13:11:30z dungvnguyen $
 * @since 1.0
 */
public class CreateBuildRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long releaseId;
  private Build build;

  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the given project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the given project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current request instance.
   */
  public CreateBuildRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the release identifier.
   */
  public Long getReleaseId() {
    return releaseId;
  }

  /**
   * Sets the given release identifier.
   *
   * @param releaseId the given release identifier to set.
   */
  public void setReleaseId(Long releaseId) {
    this.releaseId = releaseId;
  }

  /**
   * Sets the given release identifier.
   *
   * @param releaseId the given release identifier to set.
   * @return current request instance.
   */
  public CreateBuildRequest withReleaseId(Long releaseId) {
    setReleaseId(releaseId);
    return this;
  }

  /**
   * @return the build instance.
   */
  public Build getBuild() {
    return build;
  }

  /**
   * Sets the build instance.
   *
   * @param build the given build instance to set.
   */
  public void setBuild(Build build) {
    this.build = build;
  }

  /**
   * Sets the build instance.
   *
   * @param build the given build instance to set.
   * @return the current request instance.
   */
  public CreateBuildRequest withBuild(Build build) {
    setBuild(build);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateBuildRequest{\n");
    sb.append("\tprojectId: ").append(projectId).append(", \n");
    sb.append("\treleaseId: ").append(releaseId).append(", \n");
    sb.append("\tbuild: ").append(build).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
