package org.qas.qtest.api.services.link.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.link.model.ArtifactLink;

import java.util.List;

/**
 * @author trongle
 * @version $Id 4/21/2017 4:57 PM
 */
public class ArtifactLinkUnmarshaller extends AbstractUnmarshaller<List<ArtifactLink>, JsonUnmarshallerContext> {
  private static ArtifactLinkUnmarshaller instance;

  public static ArtifactLinkUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ArtifactLinkUnmarshaller();
    }

    return instance;
  }

  @Override
  public List<ArtifactLink> parse(String data) throws Exception {
    return JsonMapper.fromJson(data, new TypeReference<List<ArtifactLink>>() {
    });
  }
}
