package org.qas.qtest.api.services.link.model;

import org.qas.api.ApiServiceRequest;
import org.qas.qtest.api.internal.model.ObjectType;

import java.util.List;

/**
 * @author trongle
 * @version $Id 4/21/2017 2:51 PM
 */
public final class GetArtifactLinkRequest extends ApiServiceRequest {
  private Long projectId;

  /**
   * Artifact type
   */
  private ObjectType type;

  /**
   * Artifact id
   */
  private List<Long> artifactIds;

  public Long getProjectId() {
    return projectId;
  }

  public GetArtifactLinkRequest setProjectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

  public ObjectType getType() {
    return type;
  }

  public GetArtifactLinkRequest setType(ObjectType type) {
    this.type = type;
    return this;
  }

  public List<Long> getArtifactIds() {
    return artifactIds;
  }

  public GetArtifactLinkRequest setArtifactIds(List<Long> artifactIds) {
    this.artifactIds = artifactIds;
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetArtifactLinkRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", type=").append(type);
    sb.append(", artifactIds=").append(artifactIds);
    sb.append('}');
    return sb.toString();
  }
}
