package org.qas.qtest.api.services.link;

import org.qas.api.AuthClientException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.link.model.ArtifactLink;
import org.qas.qtest.api.services.link.model.CreateArtifactLinkRequest;
import org.qas.qtest.api.services.link.model.DeleteArtifactLinkRequest;
import org.qas.qtest.api.services.link.model.GetArtifactLinkRequest;
import org.qas.qtest.api.services.link.transform.ArtifactLinkUnmarshaller;
import org.qas.qtest.api.services.link.transform.CreateArtifactLinkMarshaller;
import org.qas.qtest.api.services.link.transform.DeleteArtifactLinkMarshaller;
import org.qas.qtest.api.services.link.transform.GetArtifactLinkMarshaller;
import org.qas.qtest.api.services.plan.model.transform.BuildJsonUnmarshaller;
import org.qas.qtest.api.services.plan.model.transform.CreateBuildRequestMarshaller;

import java.util.List;

/**
 * SearchService
 *
 * @author trongle
 * @since 1.4.2
 */
public class ArtifactLinkServiceClient extends QTestApiWebServiceClient<ArtifactLinkServiceClient>
  implements ArtifactLinkService {

  public ArtifactLinkServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
    super(credentials, clientConfiguration);
  }

  @Override
  public List<ArtifactLink> link(CreateArtifactLinkRequest in) {
    try {
      Request request = new CreateArtifactLinkMarshaller().marshall(in);
      return invoke(request, ArtifactLinkUnmarshaller.getInstance());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("An error occurs during creating artifact link.", ex);
    }
  }

  @Override
  public boolean unlink(DeleteArtifactLinkRequest in) {
    try {
      Request request = new DeleteArtifactLinkMarshaller().marshall(in);
      invoke(request, ArtifactLinkUnmarshaller.getInstance());
      return true;
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("An error occurs during delete artifact link.", ex);
    }
  }

  @Override
  public List<ArtifactLink> find(GetArtifactLinkRequest in) {
    try {
      Request request = new GetArtifactLinkMarshaller().marshall(in);
      return invoke(request, ArtifactLinkUnmarshaller.getInstance());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("An error occurs during find artifact link.", ex);
    }
  }
}
