package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.host.model.CreateAutomationAgentRequest;

/**
 * CreateAutomationAgentRequestMarshaller
 *
 * @author Thong Nguyen
 * @version $Id CreateAutomationAgentRequestMarshaller 2015-03-14 22:09:30z thongnguyen $
 * @since 1.0
 */
public class CreateAutomationAgentRequestMarshaller extends AbstractMarshaller<Request, CreateAutomationAgentRequest> {

  @Override
  protected void validateRequest(CreateAutomationAgentRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }
    // validate test case instance.
    if (in.getAgent() == null) {
      throw new AuthClientException("Invalid agent instance passed to marshall(...)");
    }
  }

  @Override
  protected void build(Request request, CreateAutomationAgentRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "HostService";
  }

  @Override
  protected String getActionName() {
    return "CreateAgent";
  }

  @Override
  protected String getContent(CreateAutomationAgentRequest in) throws Exception {
    return JsonMapper.toJson(in.getAgent());
  }

  @Override
  protected StringBuilder getResourcePath(CreateAutomationAgentRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/automation/hosts/")
      .append(in.getAgent().getHostId())
      .append("/agents");
  }

}
