package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.host.model.AutomationHost;

/**
 * AutomationHostJsonUnmarshaller
 *
 * @author Thong Nguyen
 * @version $Id AutomationHostJsonUnmarshaller 2015-03-14 22:10:30z thongnguyen $
 * @since 1.0
 */
public class AutomationHostJsonUnmarshaller extends AbstractUnmarshaller<AutomationHost, JsonUnmarshallerContext> {
  //~ class instance ==========================================================
  private static AutomationHostJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static AutomationHostJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new AutomationHostJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public AutomationHost parse(String data) throws Exception {
    return JsonMapper.parseJson(data, AutomationHost.class);
  }
}
