package org.qas.qtest.api.services.host.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateAutomationAgentRequest
 *
 * @author Thong Nguyen
 * @version $Id CreateAutomationAgentRequest 2015-03-14 22:12:30z thongnguyen $
 * @since 1.0
 */
public class CreateAutomationAgentRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private AutomationAgent agent;
  private Long projectId;

  //~ class members ===========================================================
  /**
   * @return the current agent want to register.
   */
  public AutomationAgent getAgent() {
    return agent;
  }

  /**
   * Sets the agent.
   *
   * @param agent the given agent to set.
   */
  public void setAgent(AutomationAgent agent) {
    this.agent = agent;
  }

  /**
   * Sets the agent.
   *
   * @param agent the given agent to set.
   * @return current instance.
   */
  public CreateAutomationAgentRequest withAgent(AutomationAgent agent) {
    setAgent(agent);
    return this;
  }

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current instance.
   */
  public CreateAutomationAgentRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateAutomationAgentRequest{");
    sb.append("agent=").append(agent);
    sb.append(", projectId=").append(projectId);
    sb.append('}');
    return sb.toString();
  }
}
