package org.qas.qtest.api.services.host.model;

import org.qas.api.ApiServiceRequest;

/**
 * ActivateAutomationAgentRequest
 *
 * @author Dzung Nguyen
 * @version $Id ActivateAutomationAgentRequest 2015-03-19 17:07:30z dzungvnguyen $
 * @since 1.0
 */
public class ActivateAutomationAgentRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long agentServerId;
  private Long hostServerId;
  private Boolean active;

  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier.
   * @return current instance.
   */
  public ActivateAutomationAgentRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the agent server identifier.
   */
  public Long getAgentServerId() {
    return agentServerId;
  }

  /**
   * Sets the agent server identifier.
   *
   * @param agentServerId the given agent server identifier.
   */
  public void setAgentServerId(Long agentServerId) {
    this.agentServerId = agentServerId;
  }

  /**
   * Sets the agent server identifier.
   *
   * @param agentServerId the given agent server identifier.
   * @return current request instance.
   */
  public ActivateAutomationAgentRequest withAgentServerId(Long agentServerId) {
    setAgentServerId(agentServerId);
    return this;
  }

  /**
   * @return the host server identifier.
   */
  public Long getHostServerId() {
    return hostServerId;
  }

  /**
   * Sets the host server identifier.
   *
   * @param hostServerId the given host server identifier.
   */
  public void setHostServerId(Long hostServerId) {
    this.hostServerId = hostServerId;
  }

  /**
   * Sets the host server identifier.
   *
   * @param hostServerId the given host server identifier.
   * @return current instance.
   */
  public ActivateAutomationAgentRequest withHostServerId(Long hostServerId) {
    setHostServerId(hostServerId);
    return this;
  }

  /**
   * @return the active flag, {@code true} is active, {@code false} is inactive.
   */
  public Boolean getActive() {
    return active;
  }

  /**
   * Sets the active flag.
   * <pre>
   *   true: is active.
   *   false: is inactive.
   * </pre>
   *
   * @param active the given active flag to set.
   */
  public void setActive(Boolean active) {
    this.active = active;
  }

  /**
   * Sets the active flag.
   * <pre>
   *   true: is active.
   *   false: is inactive.
   * </pre>
   *
   * @param active the given active flag to set.
   * @return the active automation agent request instance.
   */
  public ActivateAutomationAgentRequest withActive(Boolean active) {
    setActive(active);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ActivateAutomationAgentRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", agentServerId=").append(agentServerId);
    sb.append(", hostServerId=").append(hostServerId);
    sb.append(", active=").append(active);
    sb.append('}');
    return sb.toString();
  }
}
