package org.qas.qtest.api.services.host;

import java.util.List;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.host.model.*;

/**
 * HostService
 *
 * @author Thong Nguyen
 * @version $Id HostService 2015-03-14 19:04:30z thongnguyen $
 * @since 1.0
 */
public interface HostService extends QTestService {
  /**
   * Register the automation host to qTest service.
   *
   * @param automationHostRequest the given register automation host request.
   * @return the automation host information.
   * @throws AuthClientException if an error occurs during registering automation host.
   */
  AutomationHost registerAutomationHost(CreateAutomationHostRequest automationHostRequest)
      throws AuthClientException;

  /**
   * Register the automation agent to qTest service.
   *
   * @param automationAgentRequest the given register agent request to send to qTest.
   * @return the automation agent instance.
   * @throws AuthClientException if an error occurs during registering automation agent.
   */
  AutomationAgent registerAutomationAgent(CreateAutomationAgentRequest automationAgentRequest)
      throws AuthClientException;

  AutomationHost updateAutomationHost(UpdateAutomationHostRequest automationHostRequest) throws AuthClientException;
  
  /**
   * update the automation agent to qTest service.
   *
   * @param automationAgentRequest the given update agent request to send to qTest.
   * @return the automation agent instance.
   * @throws AuthClientException if an error occurs during update automation agent.
   */
  AutomationAgent updateAutomationAgent(UpdateAutomationAgentRequest automationAgentRequest)
      throws AuthClientException;
  
  /**
   * Active or inactive the automation agent to qTest service.
   *
   * @param activateAgentRequest the given activate agent request to send to qTest.
   * @throws AuthClientException if an error occurs during activating automation agent.
   */
  void activateAutomationAgent(ActivateAutomationAgentRequest activateAgentRequest)
      throws AuthClientException;
  
  /**
   * List all automation jobs from qTest server in a period
   *
   * @param listJobRequest the list jobs request.
   * @return  the list of job execution.
   * @throws AuthClientException if an error occurs during listing jobs.
   */
  List<Job> listJobs(ListJobRequest listJobRequest) throws AuthClientException;

  /**
   * Ping host.
   *
   * @param pingRequest the given ping request.
   * @return the ping message.
   * @throws AuthClientException if an error occurs during ping host.
   */
  PongMessage pingHost(PingAutomationHostRequest pingRequest) throws AuthClientException;
  
  /**
   * Update job instance status
   *
   * @param updateJobStatusRequest the given job status to set.
   * @throws AuthServiceException if an error occurs during updating job status.
   */
  void updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) throws AuthServiceException;

  /**
   * Delete automation agent
   *
   * @param deleteAutomationAgentRequest the given delete automation agent request.
   * @throws AuthClientException if an error occurs during deleting automation agent.
   */
  void deleteAutomationAgent(DeleteAutomationAgentRequest deleteAutomationAgentRequest) throws AuthClientException;
}
