package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.JsonModel;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.services.execution.model.UpdateTestRunRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * UpdateTestRunRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestRunRequestMarshaller 2015-05-31 23:22:30z dzungvnguyen $
 * @since 1.0
 */
public final class UpdateTestRunRequestMarshaller
  extends AbstractTestRunRequestMarshaller<UpdateTestRunRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(UpdateTestRunRequest testRunRequest) throws Exception {
    // validate test-run request.
    testRunRequest = ApiPreconditions.notNull(testRunRequest);
    validateProjectId(testRunRequest.getProjectId());
    validateTestRunId(testRunRequest.getTestRunId());
    ApiPreconditions.notNull(testRunRequest.getTestRun(), "Invalid test-run passed to marshall(...)");

    // create request.
    Request request = createJsonRequest(testRunRequest, "UpdateTestRun", HttpMethod.PUT);

    // create request path.
    StringBuilder pathBuilder = createApiPathBuilder(testRunRequest.getProjectId());
    pathBuilder.append("/").append(testRunRequest.getTestRunId());
    request.setResourcePath(pathBuilder.toString());

    // set request pay-load.
    request.setContent(new StringInputStream(JsonMapper.toJson(testRunRequest.getTestRun())));
    return request;
  }
}
