package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.TestSuite;

/**
 * TestSuiteJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestSuiteJsonUnmarshaller 2014-03-29 06:28:30z dungvnguyen $
 * @since 1.0
 */
public final class TestSuiteJsonUnmarshaller
  extends AbstractUnmarshaller<TestSuite, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static TestSuiteJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static TestSuiteJsonUnmarshaller getInstance() {
    if (instance == null) instance = new TestSuiteJsonUnmarshaller();
    return instance;
  }

  @Override
  public TestSuite parse(String data) throws Exception {
    return JsonMapper.parseJson(data, TestSuite.class);
  }
}
