package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.TestLog;

/**
 * TestLogJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestLogJsonUnmarshaller 2014-03-29 06:22:30z dungvnguyen $
 * @since 1.0
 */
public final class TestLogJsonUnmarshaller extends AbstractUnmarshaller<TestLog, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static TestLogJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static TestLogJsonUnmarshaller getInstance() {
    if (instance == null) instance = new TestLogJsonUnmarshaller();
    return instance;
  }

  @Override
  public TestLog parse(String data) throws Exception {
    return JsonMapper.parseJson(data, TestLog.class);
  }
}
