package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.TestCycle;

/**
 * TestCycleJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestCycleJsonUnmarshaller 2015-05-26 14:38:30z dzungvnguyen $
 * @since 1.0
 */
public final class TestCycleJsonUnmarshaller extends AbstractUnmarshaller<TestCycle, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static TestCycleJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static TestCycleJsonUnmarshaller getInstance() {
    if (instance == null) instance = new TestCycleJsonUnmarshaller();
    return instance;
  }

  @Override
  public TestCycle parse(String data) throws Exception {
    return JsonMapper.parseJson(data, TestCycle.class);
  }
}
