package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.execution.model.SubmitTestLogRequest;

/**
 * TestLogRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestLogRequestMarshaller 2014-10-24 14:44:30z dungvnguyen $
 * @since 1.0
 */
public final class SubmitTestLogRequestMarshaller extends AbstractMarshaller<Request, SubmitTestLogRequest> {

  @Override
  protected void validateRequest(SubmitTestLogRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }
    // validate project id.
    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project id passed to marshall(...)");
    }
    // validate test-run id.
    if (in.getTestRunId() == null || in.getTestRunId() <= 0) {
      throw new AuthClientException("Invalid test run id passed to marshall(...)");
    }
    // validate automation test log.
    if (in.getTestLog() == null) {
      throw new AuthClientException("Invalid test log passed to marshall(...)");
    }
  }

  @Override
  protected void build(Request request, SubmitTestLogRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "TestExecutionService";
  }

  @Override
  protected String getActionName() {
    return "SummitTestLog";
  }

  @Override
  protected String getContent(SubmitTestLogRequest in) throws Exception {
    return JsonMapper.toJson(in.getTestLog());
  }

  @Override
  protected StringBuilder getResourcePath(SubmitTestLogRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/test-runs/")
      .append(in.getTestRunId())
      .append("/test-logs");
  }
}
