package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.MoveTestSuiteRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * MoveTestSuiteRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestSuiteRequestMarshaller 2015-05-29 17:34:30z dzungvnguyen $
 * @since 1.0
 */
public final class MoveTestSuiteRequestMarshaller
  extends AbstractTestSuiteRequestMarshaller<MoveTestSuiteRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(MoveTestSuiteRequest testSuiteRequest) throws Exception {
    // validate input.
    testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
    validateProjectId(testSuiteRequest.getProjectId());

    // resolve and validate test suite identifier.
    Long testSuiteId = (testSuiteRequest.getTestSuiteId() != null
      ? testSuiteRequest.getTestSuiteId()
      : (testSuiteRequest.getTestSuite() == null ? null : testSuiteRequest.getTestSuite().getId())
    );
    validateTestSuiteId(testSuiteId);

    ApiPreconditions.notNull(testSuiteRequest.getArtifactLevel(), "Invalid artifact level passed to marshall(...)");
    validateArtifactLevel(testSuiteRequest.getArtifactLevel());
    validateArtifact(testSuiteRequest.getArtifactLevel(), testSuiteRequest.getArtifactId());

    // create update request.
    Request request = createJsonRequest(testSuiteRequest, "MoveTestSuite", HttpMethod.PUT);

    // set resource path.
    StringBuilder builder = createApiPathBuilder(testSuiteRequest.getProjectId());
    builder.append('/').append(testSuiteId.longValue());
    request.setResourcePath(builder.toString());

    // set request parameter.
    if (testSuiteRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testSuiteRequest.getArtifactId()));
    } else {
      request.addParameter("parentId", "0");
    }

    request.addParameter("parentType", testSuiteRequest.getArtifactLevel().getQueryParam());

    // set resource content.
    if (testSuiteRequest.getTestSuite() != null) {
      request.setContent(new StringInputStream(JsonMapper.toJson(testSuiteRequest.getTestSuite())));
    }

    return request;
  }
}
