package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.ListTestSuiteRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * ListTestSuiteRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestSuiteRequestMarshaller 2014-05-06 17:29:30z dungvnguyen $
 * @since 1.0
 */
public final class ListTestSuiteRequestMarshaller extends AbstractTestSuiteRequestMarshaller<ListTestSuiteRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(ListTestSuiteRequest testSuiteRequest) throws Exception {
    // validate test suite request.
    testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
    validateProjectId(testSuiteRequest.getProjectId());
    validateArtifactLevel(testSuiteRequest.getArtifactLevel());
    validateArtifact(testSuiteRequest.getArtifactLevel(), testSuiteRequest.getArtifactId());

    // create request.
    Request request = createJsonRequest(testSuiteRequest, "ListTestSuite", HttpMethod.GET);

    // build the path resource.
    request.setResourcePath(createApiPathBuilder(testSuiteRequest.getProjectId()).toString());

    // build request parameter.
    if (testSuiteRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testSuiteRequest.getArtifactId()));
      request.addParameter("parentType", testSuiteRequest.getArtifactLevel().getQueryParam());
    }

    // return the request.
    return request;
  }
}
