package org.qas.qtest.api.services.execution.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.TestSuite;

import java.util.List;

/**
 * ListTestSuiteJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestSuiteJsonUnmarshaller 2014-05-06 16:21:30z dungvnguyen $
 * @since 1.0
 */
public final class ListTestSuiteJsonUnmarshaller extends AbstractUnmarshaller<List<TestSuite>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListTestSuiteJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListTestSuiteJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListTestSuiteJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<TestSuite> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<TestSuite>>() {
    });
  }
}
