package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.ListTestRunRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * ListTestRunRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestRunRequestMarshaller 2014-05-06 16:32:30z dungvnguyen $
 * @since 1.0
 */
public final class ListTestRunRequestMarshaller extends AbstractTestRunRequestMarshaller<ListTestRunRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(ListTestRunRequest testRunRequest) throws Exception {
    // validate test-run request.
    testRunRequest = ApiPreconditions.notNull(testRunRequest);
    validateProjectId(testRunRequest.getProjectId());
    validateArtifactLevel(testRunRequest.getArtifactLevel());
    validateArtifact(testRunRequest.getArtifactLevel(), testRunRequest.getArtifactId());

    // create list execution status request.
    Request request = createJsonRequest(testRunRequest, "ListTestRun", HttpMethod.GET);

    // build the path resource.
    request.setResourcePath(createApiPathBuilder(testRunRequest.getProjectId()).toString());

    // setting parameter.
    if (testRunRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testRunRequest.getArtifactId()));
      request.addParameter("parentType", testRunRequest.getArtifactLevel().getQueryParam());
    }

    // return the request.
    return request;
  }
}
