package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.ListTestCycleRequest;

import static org.qas.qtest.api.internal.util.ApiPreconditions.notNull;

/**
 * ListTestCycleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestCycleRequestMarshaller 2015-05-28 15:42:30z dzungvnguyen $
 * @since 1.0
 */
public final class ListTestCycleRequestMarshaller extends AbstractTestCycleRequestMarshaller<ListTestCycleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(ListTestCycleRequest testCycleRequest) throws Exception {
    testCycleRequest = notNull(testCycleRequest);

    // validate project id.
    validateProjectId(testCycleRequest.getProjectId());
    validateArtifactLevel(testCycleRequest.getArtifactLevel());
    validateArtifact(testCycleRequest.getArtifactLevel(), testCycleRequest.getArtifactId());

    // create JSON request.
    Request request = createJsonRequest(testCycleRequest, "ListTestCycle", HttpMethod.GET);

    // build the path resource.
    request.setResourcePath(createApiPathBuilder(testCycleRequest.getProjectId()).toString());

    // build request parameter.
    if (testCycleRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testCycleRequest.getArtifactId()));
      request.addParameter("parentType", testCycleRequest.getArtifactLevel().getQueryParam());
    }

    // build option.
    if (testCycleRequest.isIncludeDescendants()) {
      request.addParameter("expand", "descendants");
    }

    // return the request.
    return request;
  }
}
