package org.qas.qtest.api.services.execution.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.TestCycle;

import java.util.List;

/**
 * TestCycleJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestCycleJsonUnmarshaller 2015-05-26 14:38:30z dzungvnguyen $
 * @since 1.0
 */
public final class ListTestCycleJsonUnmarshaller extends AbstractUnmarshaller<List<TestCycle>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListTestCycleJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListTestCycleJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListTestCycleJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<TestCycle> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<TestCycle>>() {
    });
  }
}
