package org.qas.qtest.api.services.execution.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.ExecutionStatus;

import java.util.List;

/**
 * ListExecutionStatusJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListExecutionStatusJsonUnmarshaller 2014-05-06 10:54:30z dungvnguyen $
 * @since 1.0
 */
public final class ListExecutionStatusJsonUnmarshaller extends AbstractUnmarshaller<List<ExecutionStatus>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListExecutionStatusJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListExecutionStatusJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListExecutionStatusJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<ExecutionStatus> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<ExecutionStatus>>() {
    });
  }
}