package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.services.execution.model.GetTestSuiteRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * GetTestSuiteRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetTestSuiteRequestMarshaller 2015-05-29 16:03:30z dzungvnguyen $
 * @since 1.0
 */
public final class GetTestSuiteRequestMarshaller
  extends AbstractTestSuiteRequestMarshaller<GetTestSuiteRequest> {
  //~ class members ===========================================================

  @Override
  public Request marshall(GetTestSuiteRequest testSuiteRequest) throws Exception {
    // validate request.
    testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
    validateProjectId(testSuiteRequest.getProjectId());
    validateTestSuiteId(testSuiteRequest.getTestSuiteId());

    // create request.
    Request request = createJsonRequest(testSuiteRequest, "GetTestSuite", HttpMethod.GET);

    // set resource path.
    StringBuilder pathBuilder = createApiPathBuilder(testSuiteRequest.getProjectId());
    pathBuilder.append('/').append(testSuiteRequest.getTestSuiteId());
    request.setResourcePath(pathBuilder.toString());

    // return current request.
    return request;
  }
}
