package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.GetTestRunRequest;

/**
 * GetTestRunRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetTestRunRequestMarshaller 2014-10-24 16:33:30z dungvnguyen $
 * @since 1.0
 */
public final class GetTestRunRequestMarshaller extends AbstractTestRunRequestMarshaller<GetTestRunRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(GetTestRunRequest getTestRunRequest) throws Exception {
    // validate request.
    getTestRunRequest = ApiPreconditions.notNull(getTestRunRequest);
    validateProjectId(getTestRunRequest.getProjectId());
    validateTestRunId(getTestRunRequest.getTestRunId());

    // validate automation test log.
    if (getTestRunRequest.getExpandOption() < 0 || getTestRunRequest.getExpandOption() > 3) {
      throw new AuthClientException("Invalid expand option passed to marshall(...)");
    }

    // create get test-run request.
    Request request = createJsonRequest(getTestRunRequest, "GetTestRun", HttpMethod.GET);

    // build the path resource.
    StringBuilder pathBuilder = createApiPathBuilder(getTestRunRequest.getProjectId());
    pathBuilder.append("/").append(getTestRunRequest.getTestRunId());

    // build option.
    if (getTestRunRequest.hasExpandOption()) {
      pathBuilder.append("?expand=");
      if (getTestRunRequest.isExpandTestStep()) {
        pathBuilder.append("testcase.teststep");
      } else if (getTestRunRequest.isExpandTestCase()) {
        pathBuilder.append("testcase");
      }
    }

    request.setResourcePath(pathBuilder.toString());

    // return the request.
    return request;
  }
}
