package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.services.execution.model.GetTestCycleRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * GetTestCycleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetTestCycleRequestMarshaller 2015-05-28 14:07:30z dzungvnguyen $
 * @since 1.0
 */
public final class GetTestCycleRequestMarshaller extends AbstractTestCycleRequestMarshaller<GetTestCycleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(GetTestCycleRequest testCycleRequest) throws Exception {
    testCycleRequest = ApiPreconditions.notNull(testCycleRequest);

    validateProjectId(testCycleRequest.getProjectId());
    validateTestCycleId(testCycleRequest.getTestCycleId());

    // create request.
    Request request = createJsonRequest(testCycleRequest, "GetTestCycle", HttpMethod.GET);

    // build the path resource and set to request.
    StringBuilder pathBuilder = createApiPathBuilder(testCycleRequest.getProjectId());
    pathBuilder.append('/');
    pathBuilder.append(testCycleRequest.getTestCycleId().longValue());
    request.setResourcePath(pathBuilder.toString());

    // build query parameters.
    if (testCycleRequest.isIncludeDescendants()) {
      request.addParameter("expand", "descendants");
    }

    // return the request.
    return request;
  }
}
