package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.services.execution.model.DeleteTestRunRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * DeleteTestRunRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestRunRequestMarshaller 2015-05-31 23:41:30z dzungvnguyen $
 * @since 1.0
 */
public final class DeleteTestRunRequestMarshaller
  extends AbstractTestRunRequestMarshaller<DeleteTestRunRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(DeleteTestRunRequest testRunRequest) throws Exception {
    // validate test-run request.
    testRunRequest = ApiPreconditions.notNull(testRunRequest);
    validateProjectId(testRunRequest.getProjectId());
    validateTestRunId(testRunRequest.getTestRunId());

    // create request.
    Request request = createJsonRequest(testRunRequest, "DeleteTestRun", HttpMethod.DELETE);

    // set resource path.
    StringBuilder pathBuilder = createApiPathBuilder(testRunRequest.getProjectId());
    pathBuilder.append("/").append(testRunRequest.getTestRunId());
    request.setResourcePath(pathBuilder.toString());

    return request;
  }
}
