package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.CreateTestRunRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * CreateTestRunRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestRunRequestMarshaller 2015-05-31 23:03:30z dzungvnguyen $
 * @since 1.0
 */
public final class CreateTestRunRequestMarshaller
  extends AbstractTestRunRequestMarshaller<CreateTestRunRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(CreateTestRunRequest testRunRequest) throws Exception {
    // validate test-run request.
    testRunRequest = ApiPreconditions.notNull(testRunRequest);
    validateProjectId(testRunRequest.getProjectId());
    validateArtifactLevel(testRunRequest.getArtifactLevel());
    validateArtifact(testRunRequest.getArtifactLevel(), testRunRequest.getArtifactId());
    ApiPreconditions.notNull(testRunRequest.getTestRun(), "Invalid test-run passed to marshall(...)");

    // create request.
    Request request = createJsonRequest(testRunRequest, "CreateTestRun", HttpMethod.POST);

    if (testRunRequest.getExternalToken() != null) {
      request.setHeader("X-External-Token", testRunRequest.getExternalToken());
    }

    // set request resource path.
    request.setResourcePath(createApiPathBuilder(testRunRequest.getProjectId()).toString());

    // set artifact type.
    if (testRunRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testRunRequest.getArtifactId().longValue()));
      request.addParameter("parentType", testRunRequest.getArtifactLevel().getQueryParam());
    }

    // set request payload.
    request.setContent(new StringInputStream(JsonMapper.toJson(testRunRequest.getTestRun())));

    return request;
  }
}
