package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.CreateTestCycleRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * CreateTestCycleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestCycleRequestMarshaller 2015-05-28 17:58:30z dzungvnguyen $
 * @since 1.0
 */
public final class CreateTestCycleRequestMarshaller
  extends AbstractTestCycleRequestMarshaller<CreateTestCycleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(CreateTestCycleRequest testCycleRequest) throws Exception {
    // validate data.
    testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
    ApiPreconditions.notNull(testCycleRequest.getTestCycle(), "Invalid test-cycle data passed to marshall(...)");
    validateProjectId(testCycleRequest.getProjectId());
    validateArtifactLevel(testCycleRequest.getArtifactLevel());
    validateArtifact(testCycleRequest.getArtifactLevel(), testCycleRequest.getArtifactId());

    // create request.
    Request request = createJsonRequest(testCycleRequest, "CreateTestCycle", HttpMethod.POST);

    // set request resource path.
    request.setResourcePath(createApiPathBuilder(testCycleRequest.getProjectId()).toString());

    // build request parameter.
    if (testCycleRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testCycleRequest.getArtifactId()));
      request.addParameter("parentType", testCycleRequest.getArtifactLevel().getQueryParam());
    }

    // set request content.
    request.setContent(new StringInputStream(JsonMapper.toJson(testCycleRequest.getTestCycle())));

    return request;
  }
}
