package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.AutomationTestLog;

/**
 * AutomationTestLogJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AutomationTestLogJsonUnmarshaller 2014-03-29 06:17:30z dungvnguyen $
 * @since 1.0
 */
public final class AutomationTestLogJsonUnmarshaller
  extends AbstractUnmarshaller<AutomationTestLog, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static AutomationTestLogJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static AutomationTestLogJsonUnmarshaller getInstance() {
    if (instance == null) instance = new AutomationTestLogJsonUnmarshaller();
    return instance;
  }

  @Override
  public AutomationTestLog parse(String data) throws Exception {
    return JsonMapper.parseJson(data, AutomationTestLog.class);
  }
}
