package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.ApiServiceRequest;
import org.qas.api.AuthClientException;
import org.qas.qtest.api.internal.model.ArtifactLevel;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * AbstractTestSuiteRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AbstractTestSuiteRequestMarshaller 2015-05-29 16:03:30z dzungvnguyen $
 * @since 1.0
 */
public abstract class AbstractTestSuiteRequestMarshaller<T extends ApiServiceRequest>
  extends AbstractTestExecutionRequestMarshaller<T> {
  //~ class properties ========================================================
  static final Set<ArtifactLevel> ACCEPT_LEVELS = new HashSet<ArtifactLevel>(
    Arrays.asList(ArtifactLevel.ROOT, ArtifactLevel.RELEASE, ArtifactLevel.TEST_CYCLE)
  );

  //~ class members ===========================================================
  /**
   * Validate test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier to validate.
   * @throws AuthClientException if an error occurs during validate test-suite identifier.
   */
  static void validateTestSuiteId(Long testSuiteId) throws AuthClientException {
    validateId(testSuiteId, "Invalid test-suite id passed to marshall(...)");
  }

  /**
   * Validate artifact level value.
   *
   * @param artifactLevel the given artifact level value to validate.
   * @throws AuthClientException if an error occurs during validating artifact type.
   */
  static void validateArtifactLevel(ArtifactLevel artifactLevel) throws AuthClientException {
    validateArtifactLevel(artifactLevel, ACCEPT_LEVELS);
  }

  @Override
  protected final String getArtifactPath() {
    return "test-suites";
  }
}
