package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * UpdateTestRunRequest
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestRunRequest 2015-05-31 23:18:30z dzungvnguyen $
 * @since 1.0
 */
public class UpdateTestRunRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testRunId;
  private TestRun testRun;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project id to set.
   * @return the current {@link UpdateTestRunRequest} object.
   */
  public UpdateTestRunRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test run id.
   */
  public Long getTestRunId() {
    return testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   */
  public void setTestRunId(Long testRunId) {
    this.testRunId = testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   * @return the current {@link UpdateTestRunRequest} object.
   */
  public UpdateTestRunRequest withTestRunId(Long testRunId) {
    setTestRunId(testRunId);
    return this;
  }

  /**
   * @return test run instance.
   */
  public TestRun getTestRun() {
    return testRun;
  }

  /**
   * Sets the test-run instance.
   *
   * @param testRun the given test-run instance.
   */
  public void setTestRun(TestRun testRun) {
    this.testRun = testRun;
  }

  /**
   * Sets the test-run instance.
   *
   * @param testRun the given test-run instance.
   * @return current create test-run request instance.
   */
  public UpdateTestRunRequest withTestRun(TestRun testRun) {
    setTestRun(testRun);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("UpdateTestRunRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testRunId=").append(testRunId);
    sb.append(", testRun=").append(testRun);
    sb.append('}');
    return sb.toString();
  }
}
