package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;
import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * ListTestSuiteRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListTestSuiteRequest 2014-05-06 17:25:30z dungvnguyen $
 * @since 1.0
 */
public class ListTestSuiteRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public ListTestSuiteRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test cycle identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the test cycle identifier where to fetch the test suites.
   *
   * @param artifactId the given test cycle identifier.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier where to fetch the test suites.
   *
   * @param artifactId the given artifact identifier to set.
   * @return the list test-suite request instance.
   */
  public ListTestSuiteRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public ListTestSuiteRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ListTestSuiteRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append('}');
    return sb.toString();
  }
}
