package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;
import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * ListTestCycleRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListTestCycleRequest 2015-05-28 15:12:30z dzungvnguyen $
 * @since 1.0
 */
public class ListTestCycleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;
  private boolean includeDescendants;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current list test-cycle request instance.
   */
  public ListTestCycleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the artifact level value, such as: ROOT, RELEASE, TEST_CYCLE.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level value.
   *
   * @param artifactLevel the given artifact level value to set.
   *                      Only accept: ROOT, RELEASE, TEST_CYCLE.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets the artifact level value.
   *
   * @param artifactLevel the given artifact level value to set.
   *                      Only accept: ROOT, RELEASE, TEST_CYCLE.
   * @return current list test-cycle request.
   */
  public ListTestCycleRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  /**
   * @return the artifact identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the artifact level identifier.
   *
   * @param artifactId the given artifact level identifier to set.
   *                   Set 0, if we want to fetch at root level.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact level identifier.
   *
   * @param artifactId the given artifact level identifier to set.
   *                   Set 0, if we want to fetch at root level.
   */
  public ListTestCycleRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return if we want to fetch test-cycle descendants.
   */
  public boolean isIncludeDescendants() {
    return includeDescendants;
  }

  /**
   * Sets the test-cycle descendant flag.
   *
   * @param includeDescendants the given test-cycle descendant flag to set.
   */
  public void setIncludeDescendants(boolean includeDescendants) {
    this.includeDescendants = includeDescendants;
  }

  /**
   * Sets the test-cycle descendant flag.
   *
   * @param includeDescendants the given test-cycle descendant flag to set.
   * @return {@link ListTestCycleRequest} instance.
   */
  public ListTestCycleRequest withIncludeDescendants(boolean includeDescendants) {
    setIncludeDescendants(includeDescendants);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ListTestCycleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", includeDescendants=").append(includeDescendants);
    sb.append('}');
    return sb.toString();
  }
}
