package org.qas.qtest.api.services.execution.model;

import org.qas.api.ApiServiceRequest;

/**
 * ListExecutionStatusRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListExecutionStatusRequest 2014-05-06 10:49:30z dungvnguyen $
 * @since 1.0
 */
public class ListExecutionStatusRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;

  //~ class members ===========================================================
  /**
   * @return the current project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public ListExecutionStatusRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }
}
