package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * DeleteTestSuiteRequest
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestSuiteRequest 2015-05-29 16:48:30z dzungvnguyen $
 * @since 1.0
 */
public class DeleteTestSuiteRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testSuiteId;

  //~ class members ===========================================================
  /**
   * @return the test-suite identifier.
   */
  public Long getTestSuiteId() {
    return testSuiteId;
  }

  /**
   * Sets the test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier to set.
   */
  public void setTestSuiteId(Long testSuiteId) {
    this.testSuiteId = testSuiteId;
  }

  /**
   * Sets the test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier to set.
   * @return the delete test-suite request instance.
   */
  public DeleteTestSuiteRequest withTestSuite(Long testSuiteId) {
    setTestSuiteId(testSuiteId);
    return this;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the delete test suite request instance.
   */
  public DeleteTestSuiteRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("DeleteTestSuiteRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testSuiteId=").append(testSuiteId);
    sb.append('}');
    return sb.toString();
  }
}
