package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * DeleteTestCycleRequest
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestCycleRequest 2015-05-29 14:59:30z dzungvnguyen $
 * @since 1.0
 */
public class DeleteTestCycleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testCycleId;
  private boolean force = false;

  //~ class members ===========================================================
  /**
   * @return the test-cycle identifier.
   */
  public Long getTestCycleId() {
    return testCycleId;
  }

  /**
   * Sets the test-cycle identifier.
   *
   * @param testCycleId the given test-cycle identifier to set.
   */
  public void setTestCycleId(Long testCycleId) {
    this.testCycleId = testCycleId;
  }

  /**
   * Sets the test-cycle identifier.
   *
   * @param testCycleId the given test-cycle identifier to set.
   * @return the delete test-cycle request instance.
   */
  public DeleteTestCycleRequest withTestCycleId(Long testCycleId) {
    setTestCycleId(testCycleId);
    return this;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the delete test-cycle request instance.
   */
  public DeleteTestCycleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return {@code true} if we want to force delete all test-cycle descendant.
   */
  public boolean isForce() {
    return force;
  }

  /**
   * Sets force delete test-cycle descendant.
   *
   * @param force the given force delete test-cycle descendant flag.
   */
  public void setForce(boolean force) {
    this.force = force;
  }

  /**
   * Sets force delete test-cycle descendant.
   *
   * @param force the given force delete test-cycle descendant flag.
   * @return the delete test-cycle request instance.
   */
  public DeleteTestCycleRequest withForce(boolean force) {
    setForce(force);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("DeleteTestCycleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", force=").append(force);
    sb.append(", testCycleId=").append(testCycleId);
    sb.append('}');
    return sb.toString();
  }
}
