package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;
import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * CreateTestRunRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestRunRequest 2015-05-31 22:59:30z dzungvnguyen $
 * @since 1.0
 */
public class CreateTestRunRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;
  private String externalToken;
  private TestRun testRun;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public CreateTestRunRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test artifact identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the test cycle identifier where to fetch the test suites.
   *
   * @param artifactId the given test artifact identifier.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier where to fetch the test suites.
   *
   * @param artifactId the given artifact identifier to set.
   * @return the create test-run request instance.
   */
  public CreateTestRunRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public CreateTestRunRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  /**
   * @return test run instance.
   */
  public TestRun getTestRun() {
    return testRun;
  }

  /**
   * Sets the test-run instance.
   *
   * @param testRun the given test-run instance.
   */
  public void setTestRun(TestRun testRun) {
    this.testRun = testRun;
  }

  /**
   * Sets the test-run instance.
   *
   * @param testRun the given test-run instance.
   * @return current create test-run request instance.
   */
  public CreateTestRunRequest withTestRun(TestRun testRun) {
    setTestRun(testRun);
    return this;
  }

  /**
   * @return the external token.
   */
  public String getExternalToken() {
    return externalToken;
  }

  /**
   * Sets the external token.
   *
   * @param externalToken the given external token to set.
   */
  public void setExternalToken(String externalToken) {
    this.externalToken = externalToken;
  }

  /**
   * Sets the external token.
   *
   * @param externalToken the given external token to set.
   * @return the current submit test log request instance.
   */
  public CreateTestRunRequest withExternalToken(String externalToken) {
    setExternalToken(externalToken);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateTestRunRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append(", testRun=").append(testRun);
    sb.append('}');
    return sb.toString();
  }
}
