package org.qas.qtest.api.services.execution.model;

public enum AutomationType {
  AUTOMATION("automation");

  AutomationType(String value) {
    this.value = value;
  }

  private final String value;

  public String getValue() {
    return value;
  }

  public static AutomationType fromName(String name) {
    for (AutomationType type : values()) {
      if (type.getValue().equalsIgnoreCase(name)) {
        return type;
      }
    }
    return null;
  }
}
