package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.UpdateTestCaseRequest;

/**
 * UpdateTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestCaseRequestMarshaller 2015-06-03 17:27:30z dzungvnguyen $
 * @since 1.0
 */
public final class UpdateTestCaseRequestMarshaller
  extends AbstractTestCaseRequestMarshaller<UpdateTestCaseRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(UpdateTestCaseRequest testCaseRequest) throws Exception {
    // validate test-case request.
    testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
    validateProjectId(testCaseRequest.getProjectId());
    validateTestCaseId(testCaseRequest.getTestCaseId());
    ApiPreconditions.notNull(
      testCaseRequest.getTestCase(),
      "Invalid test-case instance passed to marshall(...)"
    );

    // create request.
    Request request = createJsonRequest(testCaseRequest, "UpdateTestCase", HttpMethod.PUT);
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(testCaseRequest.getProjectId()));
    pathBuilder.append("/test-cases/").append(testCaseRequest.getTestCaseId());
    request.setResourcePath(pathBuilder.toString());

    // set pay-load.
    request.setContent(new StringInputStream(JsonMapper.toJson(testCaseRequest.getTestCase())));

    // return request.
    return request;
  }
}
