package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.design.model.TestStep;

/**
 * TestStepJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestStepJsonUnmarshaller 2014-03-29 05:43:30z dungvnguyen $
 * @since 1.0
 */
public final class TestStepJsonUnmarshaller extends AbstractUnmarshaller<TestStep, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static TestStepJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static TestStepJsonUnmarshaller getInstance() {
    if (instance == null) instance = new TestStepJsonUnmarshaller();
    return instance;
  }

  @Override
  public TestStep parse(String data) throws Exception {
    return JsonMapper.parseJson(data, TestStep.class);
  }
}
